' **************************************** BK1198 RADIO RECEIVER **********************************
'
'
' CSE200901 PCB
'
' Switch position functions
'
'  1 - AM
'  2 - FM
'  3 - SW1
'  4 - SW2
'  5 - SW3
'  6 - SW4

' -------------------------------------------------------------------------------------------------
'
' EEPROM Allocation
'
' The saved frequencies are in channels. AM is 1 or 9 kHz spacing,
' FM is 100 kHz spacing
' SW1 and SW2 are 5, 50 or 500 kHz spacing
'
' 1 -       Not used
' 2,3 -     Last channel saved AM
' 4,5 -     Last channel saved FM
' 6,7 -     Last channel saved SW1
' 8,9 -     Last channel saved SW2
' 10,11 -   Last channel saved SW3
' 12,13 -   Last channel saved SW4
' 14 -      Band
' 15 -      AM Step
' 16 -      SW1 step
' 17 -      SW2 step
' 18 -      SW3 step
' 19 -      SW4 step

' -------------------------------------------------------------------------------------------------
'
$regfile = "M328Pdef.dat"                                   ' Chip description
$hwstack = 160                                              ' make sure stacks big enough
$swstack = 160
$framesize = 160

$crystal = 16000000

Waitms 50

Config Com1 = 38400 , Synchrone = 0 , Parity = None , Stopbits = 1 , Databits = 8 , Clockpol = 0

Ddrb = &B11_1111                                            ' Port B direction
Portb = &B10_0100

Ddrc = &B0011_0111                                          ' Port C direction
Portc = &B0000_1100                                         ' Port C pullups

Ddrd = &B1111_0001                                          ' LCD Data
Portd = &B0000_1110



' ******************************** LONG ***********************************************************

Dim Am_frequency As Dword
Dim Fm_frequency As Dword
Dim Fm_mhz As Dword
Dim Fm_100khz As Dword
Dim Tuning_word As Dword
Dim Tune_voltage As Dword

' ******************************** WORD and INTEGER ***********************************************

Dim Am_channel As Integer
Dim Fm_channel As Integer
Dim Sw1_channel As Integer                                  'Integer                                  'Integer                                  'Integer
Dim Sw2_channel As Integer
Dim Sw3_channel As Integer
Dim Sw4_channel As Integer
Dim Sw1_frequency As Integer
Dim Sw2_frequency As Integer
Dim Sw3_frequency As Integer
Dim Sw4_frequency As Integer


Dim Switch_voltage As Word
Dim Band_count As Word
Dim Tuning_count As Dword
Dim Offset As Word
Dim Frequency As Word
Dim Multiplier As Word
Dim Band_switch As Word
Dim Band As Word
Dim Sw_mhz As Word
Dim Sw_khz As Word


' ******************************** BYTE ***********************************************************

Dim Function_switch As Byte                                 ' from 4 position switch
Dim 100hz_timer As Byte
Dim Switch As Byte
Dim Mhz As Byte
Dim I As Byte
Dim Previous As Byte
Dim Low_am As Byte
Dim High_am As Byte
Dim Low_fm As Byte
Dim High_fm As Byte
Dim Am_step As Byte
Dim Sw1_step As Byte
Dim Sw2_step As Byte
Dim Sw3_step As Byte
Dim Sw4_step As Byte
Dim Low_sw1 As Byte
Dim High_sw1 As Byte
Dim Low_sw2 As Byte
Dim High_sw2 As Byte
Dim Low_sw3 As Byte
Dim High_sw3 As Byte
Dim Low_sw4 As Byte
Dim High_sw4 As Byte
Dim Previous_band As Byte
Dim Band_store As Byte


' ********************************* BIT ***********************************************************


Dim Frequency_up As Bit
Dim Frequency_down As Bit
Dim Memory_flag As Bit


' ********************************* ALIAS **********************************************************

Cr Alias &H0D                                               ' carriage return
Lf Alias &H0A                                               ' line feed
Esc Alias &H06

Dac_4822_cs Alias Portc.2                                   ' MCP4822 chip select
Dac_4822_data Alias Portc.0                                 ' MCP4822 data
Dac_4822_clock Alias Portc.1                                ' MCP4822 clock
Dac_4822_load Alias Portd.7                                 ' MCP4822 load

Din_8551 Alias Portb.3                                      ' DAC8551 data
Sclk_8551 Alias Portb.5                                     ' DAC8551 clock
Sync_8551 Alias Portb.2                                     ' DAC8551 SYNC

' 8 BIT Timer 2 Interrupts About 100 Times / Second.

Config Timer2 = Timer , Prescale = 1024
Timer2 = 255 - 156                                          ' gives 100/sec interrupt
Config Int0 = Falling                                       ' shaft encoder
Config Int1 = Falling                                       ' push button switch on encoder
Config Adc = Single , Prescaler = Auto , Reference = Avcc
Config Lcd = 16 * 2
Cursor Off Noblink
Config Lcdpin = Pin , Db4 = Portd.4 , Db5 = Portd.5 , Db6 = Portd.6 , Db7 = Portd.7 , E = Portb.1 , Rs = Portb.0


' *************************************************************************************************

Waitms 100
Cls
Waitms 10

Print "BK1198 RX 6.0" ; Chr(cr);
Lcd "BK1198 RX 6.0   "


Wait 1                                                      ' hold it for a second
Cls



On Int0 Rotary_encoder
On Int1 Step_size                                           ' push button on encoder
On Timer2 100hz_interrupt

Enable Int0
Enable Int1
Enable Timer2
Enable Interrupts

' Restore frequencies from EEPROM
'
   Gosub Test_switch
   Locate 1 , 1
   If Band = 1 Then Gosub Show_am
   If Band = 2 Then Gosub Show_fm
   If Band = 3 Then Gosub Show_sw1
   If Band = 4 Then Gosub Show_sw2
   If Band = 5 Then Gosub Show_sw3
   If Band = 6 Then Gosub Show_sw4
   Gosub Read_stored_steps
   If Band = 1 Then Gosub Am_step_display
   If Band = 3 Then Gosub Sw1_step_display
   If Band = 4 Then Gosub Sw2_step_display
   If Band = 5 Then Gosub Sw3_step_display
   If Band = 6 Then Gosub Sw4_step_display

' **************************************** MAIN ***************************************************
'
' Looks at various flags and branches accordingly

Main:
   Gosub Test_switch                                        ' read Band switch on ADC6
   If Frequency_up = 1 Then Gosub Up_value                  ' encoder interrupt
   If Frequency_down = 1 Then Gosub Down_value
   If Memory_flag = 1 Then Gosub Save_channel               ' save current frequency
   Readeeprom Band , 12                                     ' get current band
   Goto Main

' -------------------------------------------------------------------------------------------------
'
' Frequency setting encoder sets flag, branch to appropriate tuning.

Up_value:
   Frequency_up = 0                                         ' zero flag
   If Band = 1 Then Gosub Step_1_up                         ' 9 kHz step on AM band
   If Band = 2 Then Gosub Step_100_up
   If Band = 3 Then Gosub Step_1_5_up
   If Band = 4 Then Gosub Step_2_5_up
   If Band = 5 Then Gosub Step_3_5_up
   If Band = 6 Then Gosub Step_4_5_up
   Return




' -------------------------------------------------------------------------------------------------

Down_value:
   Frequency_down = 0
   If Band = 1 Then Gosub Step_1_down
   If Band = 2 Then Gosub Step_100_down
   If Band = 3 Then Gosub Step_1_5_down
   If Band = 4 Then Gosub Step_2_5_down
   If Band = 5 Then Gosub Step_3_5_down
   If Band = 6 Then Gosub Step_4_5_down
   Return




' *********************************** SAVE FREQUENCY **********************************************
'
' When Memory_flag is set, we save the last channel and step size used in the corresponding Band.
' Channels are saved in two bytes in EEPROM.

Save_channel:
   Memory_flag = 0                                          ' zero the flag
   If Band = 1 Then Gosub Save_am_channel
   If Band = 2 Then Gosub Save_fm_channel
   If Band = 3 Then Gosub Save_sw1_channel
   If Band = 4 Then Gosub Save_sw2_channel
   If Band = 5 Then Gosub Save_sw3_channel
   If Band = 6 Then Gosub Save_sw4_channel
   Return

 Save_am_channel:
   Print "AM Channel = " ; Am_channel ; Chr(cr);
   Low_am = Low(am_channel)
   High_am = High(am_channel)
   Writeeeprom High_am , 2
   Writeeeprom Low_am , 3
   Writeeeprom Am_step , 14
   Return

 Save_fm_channel:
   Print "FM Channel = " ; Fm_channel ; Chr(cr);
   Low_fm = Low(fm_channel)
   High_fm = High(fm_channel)
   Writeeeprom High_fm , 4
   Writeeeprom Low_fm , 5
   Return

Save_sw1_channel:
   Low_sw1 = Low(sw1_channel)
   High_sw1 = High(sw1_channel)
   Writeeeprom High_sw1 , 6
   Writeeeprom Low_sw1 , 7
   Writeeeprom Sw1_step , 16
   Return



Save_sw2_channel:
   Low_sw2 = Low(sw2_channel)
   High_sw2 = High(sw2_channel)
   Writeeeprom High_sw2 , 8
   Writeeeprom Low_sw2 , 9
   Writeeeprom Sw2_step , 17
   Return



Save_sw3_channel:
   Low_sw3 = Low(sw3_channel)
   High_sw3 = High(sw3_channel)
   Writeeeprom High_sw3 , 10
   Writeeeprom Low_sw3 , 11
   Writeeeprom Sw3_step , 18
   Return



Save_sw4_channel:
   Low_sw4 = Low(sw4_channel)
   High_sw4 = High(sw4_channel)
   Writeeeprom High_sw4 , 12
   Writeeeprom Low_sw4 , 13
   Writeeeprom Sw4_step , 19
   Return

' *************************************** SHOW STORED CHANNELS ************************************
'
Show_fm:
   Readeeprom High_fm , 4
   Readeeprom Low_fm , 5
   Fm_channel = High_fm * 256
   Fm_channel = Fm_channel + Low_fm
   Locate 1 , 1
   Lcd "FM Band     "
   Print "FM Channel = " ; Fm_channel ; Chr(cr);
   Gosub Update_fm_setting
   Return

Show_am:
   Readeeprom High_am , 2
   Readeeprom Low_am , 3
   Am_channel = High_am * 256
   Am_channel = Am_channel + Low_am
   Locate 1 , 1
   Lcd "AM Band   "
   Print "AM Channel = " ; Am_channel ; Chr(cr);
   Gosub Update_am_setting
   Return

Show_sw1:
   Readeeprom High_sw1 , 6
   Readeeprom Low_sw1 , 7
   Gosub Sw1_step_display
   Sw1_channel = High_sw1 * 256
   Sw1_channel = Sw1_channel + Low_sw1
   Locate 1 , 1
   Lcd "2.7-6.5 MHz "
   Print "SW1 Channel = " ; Sw1_channel ; Chr(cr);
   Gosub Update_sw1_setting
   Return

Show_sw2:
   Readeeprom High_sw2 , 8
   Readeeprom Low_sw2 , 9
   Gosub Sw2_step_display
   sw2_channel = High_sw2 * 256
   Sw2_channel = Sw2_channel + Low_sw2
   Locate 1 , 1
   Lcd "6.4-10.25MHz"
   Print "SW2 Channel = " ; Sw2_channel ; Chr(cr);
   Gosub Update_sw2_setting
   Return

Show_sw3:
   Readeeprom High_sw3 , 10
   Readeeprom Low_sw3 , 11
   Gosub Sw3_step_display
   sw3_channel = High_sw3 * 256
   Sw3_channel = Sw3_channel + Low_sw3
   Locate 1 , 1
   Lcd "9.8-17 MHz "
   Print "SW3 Channel = " ; Sw3_channel ; Chr(cr);
   Gosub Update_sw3_setting
   Return

Show_sw4:
   Readeeprom High_sw4 , 12
   Readeeprom Low_sw4 , 13
   Gosub Sw4_step_display
   sw4_channel = High_sw4 * 256
   Sw4_channel = Sw4_channel + Low_sw4
   Locate 1 , 1
   Lcd "16.9-22 MHz "
   Print "SW4 Channel = " ; Sw4_channel ; Chr(cr);
   Gosub Update_sw4_setting
   Return

' *************************************** TUNE RF *************************************************
'
' Not used at present

Tune_rf:
   Tune_voltage = Getadc(7)
   Tune_voltage = Tune_voltage * 4096
   Tune_voltage = Tune_voltage / 930                        ' this now scales it

   Gosub Load_dac1
   Return


' -------------------------------------------------------------------------------------------------
'
' Bandswitch reads the value on ADC6. This is one of 6 values from 0 to 1023. It returns a value
' 1 to 6. 1 is FM band, 2 is AM band, 3-6 are SW1-4.

Test_switch:
   Band = Getadc(6)                                         ' gives value 0 to 1023

   Band = Band / 200                                        ' only want half MSD
   Band = Band + 1                                          ' change 0-5 to 1-6
   Band_store = Band

   If Band <> Previous_band Then Gosub Band_voltage         ' set voltage for MCP4822
   Return

' -------------------------------------------------------------------------------------------------


' Band voltage loads Channel 0 of MCP4822 DAC. The internal reference is 2048 mV
' FM1 = 33.3 mV , DAC = 67
' AM3 = 367 mV , DAC = 734
' SW1 and SW2 = 1033 mV , DAC = 2066
' SW3 and SW4 = 1100 mV , DAC = 550
' The offset loaded into DAC0 is the DAC count to set voltage on BK1198 pin 15

Band_voltage:
Print "Band = " ; Band ; Chr(cr);
   Previous_band = Band
   Locate 2 , 1
   Lcd "                "
   If Band = 1 Then Offset = 600
   If Band = 2 Then Offset = 67
   If Band = 3 Then Offset = 2060
   If Band = 4 Then Offset = 2060
   If Band = 5 Then Offset = 2200
   If Band = 6 Then Offset = 2200
   Gosub Read_stored_steps
   If Band = 1 Then Gosub Show_am
   If Band = 2 Then Gosub Show_fm
   If Band = 3 Then Gosub Show_sw1
   If Band = 4 Then Gosub Show_sw2
   If Band = 5 Then Gosub Show_sw3
   If Band = 6 Then Gosub Show_sw4


   Print "Offset = " ; Offset ; Chr(cr);
   Gosub Load_dac0                                          ' this sets voltage to set band
   If Band = 1 Then Tune_voltage = 4096
   If Band = 1 Then Gosub Load_dac1                         ' load with highest value
   Return


' Read step sizes stored in EEPROM

Read_stored_steps:
   Readeeprom Am_step , 15
   Readeeprom Sw1_step , 16
   Readeeprom Sw2_step , 17
   Readeeprom Sw3_step , 18
   Readeeprom Sw4_step , 19
   Return

' ******************************** ROTARY ENCODER ************************************************
'
' On INT0 falling edge, check PORTC.3. If high count up, if low, count down.

Rotary_encoder:
   Waitms 1                                                 ' contact bounce
   If Pinc.3 = 1 Then Frequency_up = 1
   If Pinc.3 = 0 Then Frequency_down = 1
   100hz_timer = 0                                          ' restart timer
   Return


' On INT1
' When encoder switch is pressed it counts from 0 to 2 for different step sizes. Does not work on
' FM band.
' Selects 1 or 9 kHz steps on AM
' selects 5, 50, 500 kHz steps on SW



Step_size:
   Print "Band = " ; Band_store ; Chr(cr);
   If Band_store = 1 Then Gosub Am_counter
   If Band_store = 2 Then Goto Ss_exit                      ' FM do nothing
   If Band_store = 3 Then Gosub Sw1_counter
   If Band_store = 4 Then Gosub Sw2_counter
   If Band_store = 5 Then Gosub Sw3_counter
   If Band_store = 6 Then Gosub Sw4_counter
Ss_exit:
   Return

Am_counter:
   Incr Am_step
   If Am_step = 2 Then Am_step = 0                          ' Only 0 and 1 permitted
   Writeeeprom Am_step , 15                                 ' store in EEPROM
   Gosub Am_step_display
   Return

Sw1_counter:
   Incr Sw1_step
   If Sw1_step = 3 Then Sw1_step = 0                        ' Only 0,1 and 2 permitted
   Writeeeprom Sw1_step , 16                                ' store in EEPROM
   Gosub Sw1_step_display
   Return

Sw2_counter:
   Incr Sw2_step
   If Sw2_step = 3 Then Sw2_step = 0                        ' Only 0,1 and 2 permitted
   Writeeeprom Sw2_step , 17                                ' store in EEPROM
   Gosub Sw2_step_display
   Return

Sw3_counter:
   Incr Sw3_step
   If Sw3_step = 3 Then Sw3_step = 0                        ' Only 0,1 and 2 permitted
   Writeeeprom Sw3_step , 18                                ' store in EEPROM
   Gosub Sw3_step_display
   Return

Sw4_counter:
   Incr Sw4_step
   If Sw4_step = 3 Then Sw4_step = 0                        ' Only 0,1 and 2 permitted
   Writeeeprom Sw4_step , 19                                ' store in EEPROM
   Gosub Sw4_step_display
   Return


' *************************************************************************************************
'
Am_step_display:
   Locate 1 , 11
   Readeeprom Am_step , 15
   If Am_step = 0 Then Lcd "Step 1"
   If Am_step = 1 Then Lcd "Step 9"
   Return


Sw1_step_display:
   Locate 1 , 13
   Readeeprom Sw1_step , 16
   If Sw1_step = 0 Then Lcd "  S5"
   If Sw1_step = 1 Then Lcd " S50"
   If Sw1_step = 2 Then Lcd "S500"
   Return

Sw2_step_display:
   Locate 1 , 13
   Readeeprom Sw2_step , 17
   If Sw2_step = 0 Then Lcd "  S5"
   If Sw2_step = 1 Then Lcd " S50"
   If Sw2_step = 2 Then Lcd "S500"
   Return

Sw3_step_display:
   Locate 1 , 13
   Readeeprom Sw3_step , 18
   If Sw3_step = 0 Then Lcd "  S5"
   If Sw3_step = 1 Then Lcd " S50"
   If Sw3_step = 2 Then Lcd "S500"
   Return

Sw4_step_display:
   Locate 1 , 13
   Readeeprom Sw4_step , 19
   If Sw4_step = 0 Then Lcd "  S5"
   If Sw4_step = 1 Then Lcd " S50"
   If Sw4_step = 2 Then Lcd "S500"
   Return

' ************************************ 1 KHZ STEP*************************************************
'
' On the AM band we step 1 or 9 kHz. The range is 513 to 1629 kHz. This is 1116 channels.

' DAC count = 65536/1217 * CH#
'

Step_1_up:

   If Am_step = 0 Then Incr Am_channel
   If Am_step = 1 Then Am_channel = Am_channel  + 9
   If Am_channel > 1116 Then Am_channel = 0                 ' wrap around
   Gosub Update_am_setting
   Return

Step_1_down:

   If Am_step = 0 Then Decr Am_channel
   If Am_step = 1 Then Am_channel = Am_channel - 9
   If Am_channel < 0 Then Am_channel = 1116                 ' wrap around
   Gosub Update_am_setting
   Return


Update_am_setting:
   Locate 1 , 11
   If Am_step = 0 Then Lcd "Step 1"
   If Am_step = 1 Then Lcd "Step 9"
   Am_frequency = Am_channel + 513                          ' lower band edge
   Tuning_word = 65535 * Am_channel
   Tuning_word = Tuning_word / 1116
   Print "TW AM = " ; Tuning_word ; Chr(cr);
   Gosub Load_dac_8551
   Locate 2 , 1
   Lcd "F = " ; Am_frequency ; " kHz  "
   Return



' ************************************ 5 KHZ STEP*************************************************
'
' On the SW band we step 5 KhZ.
' SW10 range is 2700 - 10250 kHz. This is 1510 channels
' This is divided into two bands
' SW1 is 2700 - 6500 kHz, channels 0 to 760
' SW2 is 6400 - 10250 kHz, channels 740 to 1510

' SW11 range is 9800 - 22000 kHz. This is 2440 channels
' This is divided into two bands
' SW3 is 9800 - 17000 kHz, channels 0 to 1440
' SW4 is 16900 - 22000 kHz, channels 1420 to 2440

' The ADC has a range from 0 to 1200 mV in 18.3105 uV steps.
'

Step_1_5_up:

   If Sw1_step = 0 Then Incr Sw1_channel
   If Sw1_step = 1 Then Sw1_channel = Sw1_channel + 10
   If Sw1_step = 2 Then Sw1_channel = Sw1_channel + 100
   If Sw1_channel > 760 Then Sw1_channel = 0                ' wrap around
   Gosub Update_sw1_setting
   Return

Step_1_5_down:

   If Sw1_step = 0 Then Decr Sw1_channel
   If Sw1_step = 1 Then Sw1_channel = Sw1_channel - 10
   If Sw1_step = 2 Then Sw1_channel = Sw1_channel - 100
   If Sw1_channel < 0 Then Sw1_channel = 760                ' wrap around
   Gosub Update_sw1_setting
   Return


Update_sw1_setting:
   Gosub Sw1_step_display
   Sw1_frequency = Sw1_channel * 5
   Sw1_frequency = Sw1_frequency + 2700
   Tuning_word = 65536 * Sw1_channel
   Tuning_word = Tuning_word / 1510
   Print "CH = " ; Sw1_channel ; " TW1 = " ; Tuning_word ; Chr(cr);
   Gosub Load_dac_8551

   Sw_mhz = Sw1_frequency / 1000
   Sw_khz = Sw1_frequency Mod 1000

   Locate 2 , 1
    Lcd "F = " ; Sw_mhz ; "." ;
   If Sw_khz < 100 Then Lcd "0"
   If Sw_khz < 10 Then Lcd "0"
   Lcd Sw_khz ; " MHz  "
   Return

' -------------------------------------------------------------------------------------------------

Step_2_5_up:

   If Sw2_step = 0 Then Incr Sw2_channel
   If Sw2_step = 1 Then Sw2_channel = Sw2_channel + 10
   If Sw2_step = 2 Then Sw2_channel = Sw2_channel + 100
   If Sw2_channel > 1510 Then Sw2_channel = 740             ' wrap around
   Gosub Update_sw2_setting
   Return

Step_2_5_down:

   If Sw2_step = 0 Then Decr Sw2_channel
   If Sw2_step = 1 Then Sw2_channel = Sw2_channel - 10
   If Sw2_step = 2 Then Sw2_channel = Sw2_channel - 100
   If Sw2_channel < 740 Then Sw2_channel = 1510             ' wrap around
   Gosub Update_sw2_setting
   Return


Update_sw2_setting:

   Sw2_frequency = Sw2_channel * 5
   Sw2_frequency = Sw2_frequency + 2700
   Tuning_word = 65535 * Sw2_channel
   Tuning_word = Tuning_word / 1510
   Print "CH = " ; Sw2_channel ; " TW2 = " ; Tuning_word ; Chr(cr);
   Gosub Load_dac_8551
   Locate 2 , 1
   Sw_mhz = Sw2_frequency / 1000
   Sw_khz = Sw2_frequency Mod 1000

   Locate 2 , 1
   Lcd "F = " ; Sw_mhz ; "." ;
   If Sw_khz < 100 Then Lcd "0"
   If Sw_khz < 10 Then Lcd "0"
   Lcd Sw_khz ; " MHz  "
   Return

' -------------------------------------------------------------------------------------------------

Step_3_5_up:

   If Sw3_step = 0 Then Incr Sw3_channel
   If Sw3_step = 1 Then Sw3_channel = Sw3_channel + 10
   If Sw3_step = 2 Then Sw3_channel = Sw3_channel + 100
   If Sw3_channel > 1440 Then Sw3_channel = 0               ' wrap around
   Gosub Update_sw3_setting
   Return

Step_3_5_down:

   If Sw3_step = 0 Then Decr Sw3_channel
   If Sw3_step = 1 Then Sw3_channel = Sw3_channel - 10
   If Sw3_step = 2 Then Sw3_channel = Sw3_channel - 100
   If Sw3_channel < 0 Then Sw3_channel = 1440               ' wrap around
   Gosub Update_sw3_setting
   Return


Update_sw3_setting:
   Gosub Sw3_step_display
   Sw3_frequency = Sw3_channel * 5
   Sw3_frequency = Sw3_frequency + 9800
   Tuning_word = 65535 * Sw3_channel
   Tuning_word = Tuning_word / 2440
   Print " TW3A = " ; Tuning_word ; Chr(cr);
   Gosub Load_dac_8551
   Locate 2 , 1
   Sw_mhz = Sw3_frequency / 1000
   Sw_khz = Sw3_frequency Mod 1000
   Lcd "F = " ; Sw_mhz ; "." ;
   If Sw_khz < 100 Then Lcd "0"
   If Sw_khz < 10 Then Lcd "0"
   Lcd Sw_khz ; " MHz  "
   Return

' -------------------------------------------------------------------------------------------------

Step_4_5_up:

   If Sw4_step = 0 Then Incr Sw4_channel
   If Sw4_step = 1 Then Sw4_channel = Sw4_channel + 10
   If Sw4_step = 2 Then Sw4_channel = Sw4_channel + 100
   If Sw4_channel > 2440 Then Sw4_channel = 1420            ' wrap around
   Gosub Update_sw4_setting
   Return

Step_4_5_down:

   If Sw4_step = 0 Then Decr Sw4_channel
   If Sw4_step = 1 Then Sw4_channel = Sw4_channel - 10
   If Sw4_step = 2 Then Sw4_channel = Sw4_channel - 100
   If Sw4_channel < 1420 Then Sw4_channel = 2440            ' wrap around
   Gosub Update_sw4_setting
   Return


Update_sw4_setting:
  ' Locate 1 , 1
  ' Lcd "Ch " ; Sw4_channel                                  ' ; "     "
  ' Gosub Sw4_step_display
   Sw4_frequency = Sw4_channel * 5
   Sw4_frequency = Sw4_frequency + 9800
   Tuning_word = 65535 * Sw4_channel
   Tuning_word = Tuning_word / 2440
   Print " TW4A = " ; Tuning_word ; Chr(cr);
   Gosub Load_dac_8551
   Locate 2 , 1
   Sw_mhz = Sw4_frequency / 1000
   Sw_khz = Sw4_frequency Mod 1000
    Lcd "F = " ; Sw_mhz ; "." ;
   If Sw_khz < 100 Then Lcd "0"
   If Sw_khz < 10 Then Lcd "0"
   Lcd Sw_khz ; " MHz  "
   Return




' ************************************ 9 KHZ STEP *************************************************
'
' Every time encoder up or down pulse, shift frequency 9 kHz up or down.
' There are 123 channels at 9 kHz spacing

Step_9_up:
   Am_channel = Am_channel + 9
   If Am_channel > 1217 Then Am_channel = 0                 ' wrap around
   Gosub Update_am_setting
   Return

Step_9_down:
   Am_channel = Am_channel - 9
   If Am_channel < 0 Then Am_channel = 1217                 ' wrap around
   Gosub Update_am_setting
   Return

 ' ***************************** FM CHANNELS 100 KHZ STEPS ****************************************
'
' On the FM band we step 100 KhZ. The range is 87 to 108 MHz. This is 210 channels.
' The ADC has a range from 0 to 1200 mV in 18.3105 uV steps.
'
' DAC count = 65536/215 * CH#

 Step_100_up:
   Incr Fm_channel
   If Fm_channel > 210 Then Fm_channel = 0                  ' top limit
   Gosub Update_fm_setting
   Return

 Step_100_down:
   Decr Fm_channel
   If Fm_channel < 0 Then Fm_channel = 210                  ' top limit
   Gosub Update_fm_setting
   Return

Update_fm_setting:
   Locate 1 , 9
   Lcd "Step 100"
   Fm_frequency = Fm_channel * 100
   Fm_frequency = Fm_frequency + 87000                      ' 87000 is low band edge
   Tuning_word = Fm_channel * 65536
   Tuning_word = Tuning_word / 210
   Gosub Load_dac_8551
   Fm_mhz = Fm_frequency / 1000
   Fm_100khz = Fm_frequency Mod 1000
   Locate 2 , 1
   Lcd "F = " ; Fm_mhz ; "." ;
   If Fm_100khz = 0 Then Lcd "000   " Else Lcd Fm_100khz ;
   Locate 2 , 14
   Lcd "MHz"
   100hz_timer = 0
   Return


' ******************************** DAC LOAD ******************************************************
'
' The DAC is an MC4822 12 bit.
' Protocol:
' Take CS low (PORTC.2)
' Clock in 16 bits, data on PORTC.0, clock on PORTC.1
' Raise CS
' Pulse LDAC low (PORTC.3)
' Inserted NOPs for longer pulses but these are not reall necessary

' DAC0 is band selection
' DAC1 is LNA tuning

' DAC0     0011 + 12 DATA bits
' DAC1     1001 + 12 DATA bits


Load_dac0:
   Band_count = &B0011_0000_0000_0000                       ' select DAC0
   Band_count = Band_count + Offset                         ' add in
   Dac_4822_cs = 0                                           ' Lower CS
   For I = 1 To 16
   Dac_4822_data = Band_count.15
   Dac_4822_clock = 1                                       ' pulse clock
   nop
   Dac_4822_clock = 0
   Rotate Band_count , Left , 1
   Next
   Dac_4822_cs = 1                                          ' raise CS
   Dac_4822_load = 0                                        ' puls LDAC low
   nop
   Dac_4822_load = 1
   Return


' ********************************** DAC1 *********************************************************
'
' This is not used, does not seem to work,
'
' DAC1 controls the resonant frequency of the SW bands. It controld the varicap D8.
'
' The output voltage is in the range 0 - 4.096V with gain bit 13 set to 0 for 2X.
' Amplifier U4A following has a gain of 2.833 to give range 0 - 11.6V

Load_dac1:
   Tuning_count = &B1001_0000_0000_0000                     ' select DAC1
   Tuning_count = Tuning_count + Tune_voltage
  ' Print "Tuning count = " ; Bin(tuning_count) ; Chr(cr);
   Dac_4822_cs = 0                                          ' Lower CS
   For I = 1 To 16
   Dac_4822_data = Tuning_count.15
   nop
   Dac_4822_clock = 1                                        ' pulse clock
   nop                                                      ' extend pulse a bit
   Dac_4822_clock = 0
   Rotate Tuning_count , Left , 1
   Next
   Dac_4822_cs = 1                                           ' raise CS

   Dac_4822_load = 0                                        ' pulse LDAC low
   nop
   Dac_4822_load = 1
   Return




' ************************************** DAC8551 LOADING ******************************************
'
' The DAC8551 is 16 bits and controls the tuning of the BK1198 receiver chip. It uses the reference of
' 1.2V so each bit change is 18.31 uV
'
' A 24 bit word is sent to the chip.
' First take SYNC bit low
' Then clock in 24 bits into DIN with SCLK
' Then take SYNC bit high.
'
' The word loaded is as follows
' 8 bits all zero followed by 16 data bits
' Entry is tuning_word
'



Load_dac_8551:
   Sync_8551 = 0                                            ' Lower Sync
   nop
   For I = 1 To 8                                           ' 8 zero bits
   Din_8551 = 0
   nop
   Sclk_8551 = 1                                            ' pulse clock
   nop
   Sclk_8551 = 0
   Next
   For I = 1 To 16
   Din_8551 = Tuning_word.15                                ' top bit of data
   nop
   Rotate Tuning_word , Left , 1
   Sclk_8551 = 1                                            ' pulse clock
   nop
   Sclk_8551 = 0
   Next
   nop
   Sync_8551 = 1                                            ' raise sync
   Return




' ***************************** 100 HZ INTERRUPT **************************************************

100hz_interrupt:
   Timer2 = 255 - 156                                       ' reload timer
   Incr 100hz_timer
   If 100hz_timer = 30 Then Set Memory_flag                 ' in 300 mS set flag
   If 100hz_timer = 100 Then 100hz_timer = 99               ' stay there
   Return